# バッチ設計書 5-Garbage Collector

## 概要

本ドキュメントは、Kubernetesリソースの汎用ガベージコレクターであるGarbage Collectorの設計を記述する。OwnerReferenceに基づくカスケード削除を実行する。

### 本バッチの処理概要

Garbage Collectorは、Kubernetesの全リソースタイプに対して、OwnerReferenceに基づく親子関係の依存グラフを構築・維持し、親リソース削除時に子リソースを自動的にカスケード削除またはOrphan化するコントローラーである。

**業務上の目的・背景**：Kubernetesのリソース間には親子関係（OwnerReference）が存在し、親リソース（Deployment, ReplicaSet, Job等）が削除された際に子リソース（Pod, ReplicaSet等）が孤立するのを防ぐ必要がある。Garbage Collectorは、依存関係グラフを構築してリソース間の関係を管理し、親リソースの削除に伴う子リソースの自動クリーンアップを実現する。これにより、etcdストレージの不要リソース蓄積を防止する。

**バッチの実行タイミング**：全APIリソースのInformerで変更を監視し、依存グラフの変更に基づいてイベント駆動で随時実行される。Discovery APIの変更も定期的に同期される。

**主要な処理内容**：
1. dependencyGraphBuilderによる全リソースの依存関係グラフ構築
2. リソース変更の監視（全APIリソースタイプのInformer）
3. attemptToDeleteキュー: 削除可能なリソースの削除処理
4. attemptToOrphanキュー: 子リソースのOrphan化処理（OwnerReference除去）
5. absentOwnerCache: 不在オーナーのキャッシュ管理
6. Discovery APIとの定期同期（新しいリソースタイプの検出）
7. REST Mapperのリセットとモニター再同期

**前後の処理との関連**：全てのKubernetesコントローラーが作成するリソースのOwnerReferenceに基づいて動作する。StorageVersionMigratorはGarbage CollectorのGraphBuilderのモニターを利用する。

**影響範囲**：全Kubernetesリソース。全NamespaceおよびClusterスコープリソース。

## バッチ種別

ガベージコレクション型（依存関係ベースカスケード削除）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | 常時稼働 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | リソース変更イベント（全APIリソースタイプ） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| kube-controller-manager起動 | Garbage Collectorはkube-controller-manager内で起動 |
| Discovery API利用可能 | 削除可能なリソースタイプの一覧取得 |
| API Server接続 | kube-apiserverと通信可能であること |

### 実行可否判定

dependencyGraphBuilderのキャッシュ同期が完了した場合にワーカーを起動する。同期がタイムアウトした場合でも処理を継続する（"not all resource monitors could be synced, proceeding anyways"）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| workers | int | Yes | なし | ワーカーの並列数 |
| initialSyncTimeout | time.Duration | Yes | なし | 初期同期タイムアウト |
| ignoredResources | map[schema.GroupResource]struct{} | Yes | なし | GC対象外リソース |
| ResourceResyncTime | time.Duration | No | 0 | Informerの再同期期間 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 全APIリソースInformer | Kubernetes API (metadata) | 全リソースタイプの変更イベント |
| Discovery API | Kubernetes API | 削除可能リソースタイプ一覧 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| リソース削除 | Kubernetes API (metadata) | 子リソースのカスケード削除 |
| OwnerReference更新 | Kubernetes API (metadata) | Orphan化時のOwnerReference除去 |
| Event | Kubernetes API (core/v1 Event) | GC関連イベント |

### 出力ファイル仕様

ファイル出力はなし。

## 処理フロー

### 処理シーケンス

```
1. GarbageCollector初期化（NewGarbageCollector）
   └─ GraphBuilder作成、キュー初期化、absentOwnerCache作成
2. Run起動
   ├─ EventBroadcaster開始
   ├─ GraphBuilder起動（依存グラフ構築開始）
   ├─ キャッシュ同期待ち（タイムアウト付き）
   └─ attemptToDelete/attemptToOrphanワーカー起動
3. GraphBuilderがグラフ変更を検知
   ├─ attemptToDeleteキューにノード投入
   └─ attemptToOrphanキューにノード投入
4. attemptToDeleteワーカー
   └─ 子リソースの削除処理
5. attemptToOrphanワーカー
   └─ 子リソースのOwnerReference除去
6. Sync（定期Discovery同期）
   └─ 新リソースタイプ検出時にモニター再起動
```

### フローチャート

```mermaid
flowchart TD
    A[GC起動] --> B[GraphBuilder起動]
    B --> C[全リソースInformer監視開始]
    C --> D[依存関係グラフ構築]
    D --> E{リソース変更検知}
    E --> F{削除対象?}
    F -->|Yes| G[attemptToDeleteキュー投入]
    F -->|Orphan| H[attemptToOrphanキュー投入]
    G --> I[カスケード削除実行]
    H --> J[OwnerReference除去]
    I --> E
    J --> E
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース監視 | etcd (全リソース) | SELECT | Informer経由のwatch |
| リソース削除 | etcd (全リソース) | DELETE | カスケード削除 |
| OwnerReference更新 | etcd (全リソース) | PATCH | Orphan化時 |
| Discovery API | API Server | SELECT | 利用可能リソースタイプ取得 |

### テーブル別操作詳細

#### 全リソース (metadata)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | metadata.ownerReferences | 親リソース参照 | 依存グラフ構築 |
| DELETE | - | 親リソース削除済み | カスケード削除 |
| PATCH | metadata.ownerReferences | 削除対象のOwnerReference除去 | Orphan化 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | リソース削除失敗 | 権限不足、NotFound | リキュー or スキップ |
| - | Discovery APIエラー | API Server通信エラー | メトリクス記録、次周期で再試行 |
| - | 初期同期タイムアウト | リソースモニター同期遅延 | 警告ログ出力、処理続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（レートリミッター制御） |
| リトライ間隔 | TypedRateLimitingQueue（1秒ワーカーループ） |
| リトライ対象エラー | API Server通信エラー、リソース操作エラー |

### 障害時対応

コントローラー再起動時にGraphBuilderが依存グラフを再構築する。absentOwnerCacheにより不在オーナーの重複チェックを効率化する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | リソースノード単位 |
| コミットタイミング | 各リソース操作APIコール時 |
| ロールバック条件 | 操作失敗時はリキュー |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | クラスタ内全リソース数に依存 |
| 目標処理時間 | ワーカーループ間隔 = 1秒 |
| メモリ使用量上限 | 依存関係グラフサイズに依存 |

## 排他制御

- attemptToDeleteとattemptToOrphanの2つの独立したworkqueue
- 各ワーカーは1秒間隔で実行
- API Serverの楽観的並行性制御（ResourceVersion）
- absentOwnerCacheによる重複オーナー確認の効率化

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | コントローラー起動時 | "Starting controller garbagecollector" |
| 進捗ログ | 同期完了時 | "all resource monitors have synced" / "Proceeding to collect garbage" |
| 終了ログ | コントローラー停止時 | "Shutting down controller garbagecollector" |
| エラーログ | Discovery同期エラー時 | "no resources reported by discovery, skipping garbage collector sync" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| garbage_collector_resources_sync_error | メトリクス（Prometheusで監視） | クラスタ管理者 |
| workqueue深さ（attemptToDelete/attemptToOrphan） | メトリクス（Prometheusで監視） | クラスタ管理者 |

## 備考

- ソースコード: `pkg/controller/garbagecollector/garbagecollector.go`
- GraphBuilder: `pkg/controller/garbagecollector/graph_builder.go`
- ResourceResyncTime = 0（再同期なし）
- metadataClientを使用してリソース操作を効率化
- controller.Interface と controller.Debuggable インターフェースを実装
- StorageVersionMigratorがGraphBuilderのGetMonitorを利用
